function [h,dh_dx] = h_NWLS(Y,V,idx_V,idx_S)
% [h,dh_dx] = h_NWLS(Y,V,idx_V,idx_S)
%
% INPUT
% - Y       Nodal admittance matrix.
% - V       Estimated voltage phasors.
% - idx_V   Locations of voltage phasor measurements.
% - idx_S   Locations of active/reactive power measurements.
%
% OUTPUT
% - h       Value of the nonlinear measurement function.
% - dh_dx   Jacobian matrix of the nonlinear measurement function.

n_SE = size(Y,1); % Number of voltage phasor estimates.

%% Function value

I = Y * V;
S = V .* conj(I);

Vabs = abs(V);
Varg = angle(V);
P = real(S);
Q = imag(S);

h = [Vabs(idx_V);Varg(idx_V);P(idx_S);Q(idx_S)];

%% Jacobian matrix

% Voltage magnitude measurements

% ******************************
% ! Write your own code here !
% ******************************

dVabs_dVabs = [];
dVabs_dVarg = [];
dVarg_dVabs = [];
dVarg_dVarg = [];

% ******************************

% Active/reactive power measurements

G = real(Y);
B = imag(Y);

dP_dVabs = zeros(n_SE,n_SE);
dP_dVarg = zeros(n_SE,n_SE);
dQ_dVabs = zeros(n_SE,n_SE);
dQ_dVarg = zeros(n_SE,n_SE);

for i=1:n_SE
    for j=1:n_SE
        G_ij = G(i,j);
        B_ij = B(i,j);
        V_i = Vabs(i);
        V_j = Vabs(j);
        delta_ij = Varg(i)-Varg(j);
        
        % ******************************
        % ! Write your own code here !
        % ******************************
        
        % ...
        
        % ******************************
    end
end

% ******************************
% ! Write your own code here !
% ******************************

% ...

% ******************************

dh_dx = [dVabs_dVabs,dVabs_dVarg;dVarg_dVabs,dVarg_dVarg;dP_dVabs,dP_dVarg;dQ_dVabs,dQ_dVarg];

end